//
//  GlyphsFilterProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.05.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSLayer;
@class GSFont;

/*! \brief GlyphsFilter: The protocol defining the filter plugin interface
 \ingroup common
 The protocol defining the filter plugin interface.
 */
@protocol GlyphsFilter
/** The interface version.*/
@property (nonatomic, readonly) NSUInteger interfaceVersion;
/** The title of the plugin.*/
@property (nonatomic, readonly) NSString *title;
/** The keyEquivalent to select the Filter.*/
@property (nonatomic, readonly) NSString *keyEquivalent;
/** the Controller of type GSEditViewController */
@property (nonatomic, unsafe_unretained) id controller;


//! Glyphs will call that before the filter is invoked.
- (NSError*) setup ;

//! this method will be called if one layer is active in Edit View (the nodes are visible) Pay attention to the selection.
- (BOOL) runFilterWithLayer:(GSLayer*) Layer error: (NSError**) error ;
//! this method will be called if the hole glyph is supposed to be processed.
- (BOOL) runFilterWithLayers:(NSArray*) Layers error: (NSError**) error ;
@optional
@property (nonatomic, readonly) NSView * view;
//! is set, if the user choos "run last Filter". Then it should keep the settings from the last run.
@property (nonatomic) BOOL rerun;

//! the returned value will be placed as the title of the "OK" button in the filter dialog.
- (NSString*) actionName;

//! This will be call if the filter should be run from on export of the font. (see: Instance > Custom Properties)
- (BOOL) filterNeedsRemoveOverlap;
- (void) processFont:(GSFont*)Font withArguments: (NSArray*) Arguments ;
- (void) processLayer:(GSLayer*)Layer withArguments: (NSArray*) Arguments ;

@end

NSSet* getIncludeExcludeGlyphList(NSArray* Arguments, BOOL* Include);
